package inc.monsters.mias.data;

import java.io.Serializable;
import javax.persistence.*;

import java.util.Date;
import java.util.List;


/**
 * The persistent class for the EMPLOYEES database table.
 * 
 */
@Entity
@Table(name="EMPLOYEES", schema="APP")
@NamedQueries({
		@NamedQuery(name="Employee.all", query="SELECT emp FROM Employee emp"),
		@NamedQuery(name="Employee.byId", query="SELECT emp FROM Employee emp WHERE emp.id = :id")
})
public class Employee implements Serializable {
	private static final long serialVersionUID = 1L;
	private int id;
	private Date birthDate;
	private String firstName;
	private Date hireDate;
	private String jobTitle;
	private String lastName;
	private int salary;
	private int kidsScared;
	private List<Kid> kids;

    public Employee() {
    }

	@Id
	@GeneratedValue(strategy=GenerationType.AUTO)
	public int getId() {
		return this.id;
	}

	public void setId(int id) {
		this.id = id;
	}

	@Temporal(TemporalType.DATE)
	@Column(name="BIRTH_DATE")
	public Date getBirthDate() {
		return this.birthDate;
	}

	public void setBirthDate(Date birthDate) {
		this.birthDate = birthDate;
	}


	@Column(name="FIRST_NAME")
	public String getFirstName() {
		return this.firstName;
	}

	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}


	@Temporal(TemporalType.DATE)
	@Column(name="HIRE_DATE")
	public Date getHireDate() {
		return this.hireDate;
	}

	public void setHireDate(Date hireDate) {
		this.hireDate = hireDate;
	}


	@Column(name="JOB_TITLE")
	public String getJobTitle() {
		return this.jobTitle;
	}

	public void setJobTitle(String jobTitle) {
		this.jobTitle = jobTitle;
	}


	@Column(name="LAST_NAME")
	public String getLastName() {
		return this.lastName;
	}

	public void setLastName(String lastName) {
		this.lastName = lastName;
	}


	public int getSalary() {
		return this.salary;
	}

	public void setSalary(int salary) {
		this.salary = salary;
	}
	

	@Column(name="KIDS_SCARED")
	public int getKidsScared() {
		return kidsScared;
	}

	public void setKidsScared(int kidsScared) {
		this.kidsScared = kidsScared;
	}
	
	@Transient
	public String getName() {
		return firstName + " " + lastName;
	}

	@OneToMany(mappedBy="employee")
	public List<Kid> getKids() {
		return kids;
	}

	public void setKids(List<Kid> kids) {
		this.kids = kids;
	}
	
	@Transient
	public void increaseKidsScared() {
		setKidsScared(getKidsScared() + 1);
	}
}